/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.mixin.common.collision;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.SectionPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.IPMcHelper;
import qouteall.imm_ptl.core.api.ImmPtlEntityExtension;
import qouteall.imm_ptl.core.collision.PortalCollisionHandler;
import qouteall.imm_ptl.core.ducks.IEEntity;
import qouteall.imm_ptl.core.miscellaneous.IPVanillaCopy;
import qouteall.imm_ptl.core.portal.EndPortalEntity;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.my_util.LimitedLogger;

@Mixin(value={Entity.class})
public abstract class MixinEntity
implements IEEntity,
ImmPtlEntityExtension {
    @Unique
    @Nullable
    private PortalCollisionHandler ip_portalCollisionHandler;
    @Shadow
    private Level f_19853_;
    @Shadow
    public int f_19797_;
    @Shadow
    private Vec3 f_19825_;
    @Shadow
    private BlockPos f_19826_;
    @Shadow
    @Nullable
    private BlockState f_185934_;
    @Shadow
    private ChunkPos f_185933_;
    private static final LimitedLogger limitedLogger = new LimitedLogger(20);

    @Shadow
    protected abstract Vec3 m_20272_(Vec3 var1);

    @Shadow
    public abstract Component m_7755_();

    @Shadow
    public abstract double m_20185_();

    @Shadow
    public abstract double m_20186_();

    @Shadow
    public abstract double m_20189_();

    @Shadow
    protected abstract void m_146912_();

    @Shadow
    protected abstract AABB m_20217_(Pose var1);

    @Redirect(method={"Lnet/minecraft/world/entity/Entity;move(Lnet/minecraft/world/entity/MoverType;Lnet/minecraft/world/phys/Vec3;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;collide(Lnet/minecraft/world/phys/Vec3;)Lnet/minecraft/world/phys/Vec3;"))
    private Vec3 redirectHandleCollisions(Entity entity, Vec3 attemptedMove) {
        if (!IPGlobal.enableServerCollision && !entity.m_9236_().m_5776_()) {
            if (entity instanceof Player) {
                return attemptedMove;
            }
            return Vec3.f_82478_;
        }
        if (attemptedMove.m_82556_() > 3600.0) {
            limitedLogger.invoke(() -> {
                Helper.err("Skipping collision calculation because entity moves too fast %s%s%d".formatted(entity, attemptedMove, entity.m_9236_().m_46467_()));
                new Throwable().printStackTrace();
            });
            return attemptedMove;
        }
        if (!IPGlobal.crossPortalCollision || this.ip_portalCollisionHandler == null || !this.ip_portalCollisionHandler.hasCollisionEntry()) {
            Vec3 normalCollisionResult = this.m_20272_(attemptedMove);
            return normalCollisionResult;
        }
        Vec3 result = this.ip_portalCollisionHandler.handleCollision((Entity)this, attemptedMove);
        return result;
    }

    @Inject(method={"Lnet/minecraft/world/entity/Entity;fireImmune()Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void onIsFireImmune(CallbackInfoReturnable<Boolean> cir) {
        if (this.ip_getCollidingPortal() instanceof EndPortalEntity) {
            cir.setReturnValue((Object)true);
            cir.cancel();
        }
    }

    @Redirect(method={"Lnet/minecraft/world/entity/Entity;checkInsideBlocks()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;getBoundingBox()Lnet/minecraft/world/phys/AABB;"))
    private AABB redirectBoundingBoxInCheckingBlockCollision(Entity entity) {
        return this.ip_getActiveCollisionBox(entity.m_20191_());
    }

    @Inject(method={"checkInsideBlocks"}, at={@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/world/entity/Entity;getBoundingBox()Lnet/minecraft/world/phys/AABB;", shift=At.Shift.AFTER)}, locals=LocalCapture.CAPTURE_FAILHARD, cancellable=true)
    private void onCheckInsideBlocks(CallbackInfo ci, AABB box) {
        if (box == null) {
            ci.cancel();
        }
    }

    @Inject(method={"Lnet/minecraft/world/entity/Entity;isInWall()Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void onIsInsideWall(CallbackInfoReturnable<Boolean> cir) {
        if (this.ip_isRecentlyCollidingWithPortal()) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"Lnet/minecraft/world/entity/Entity;setPosRaw(DDD)V"}, at={@At(value="HEAD")})
    private void onSetPos(double nx, double ny, double nz, CallbackInfo ci) {
        Entity this_ = (Entity)this;
        if (this_ instanceof ServerPlayer && IPGlobal.teleportationDebugEnabled && (Math.abs(this.m_20185_() - nx) > 10.0 || Math.abs(this.m_20186_() - ny) > 10.0 || Math.abs(this.m_20189_() - nz) > 10.0)) {
            Helper.log(String.format("%s %s teleported from %s %s %s to %s %s %s", this.m_7755_().m_214077_(), this.f_19853_.m_46472_(), (int)this.m_20185_(), (int)this.m_20186_(), (int)this.m_20189_(), (int)nx, (int)ny, (int)nz));
            new Throwable().printStackTrace();
        }
    }

    @Overwrite
    public boolean m_20175_(Pose pose) {
        Entity this_ = (Entity)this;
        AABB activeCollisionBox = this.ip_getActiveCollisionBox(this.m_20217_(pose));
        if (activeCollisionBox == null) {
            return true;
        }
        return this.f_19853_.m_45756_(this_, activeCollisionBox.m_82406_(1.0E-7));
    }

    @Inject(method={"Lnet/minecraft/world/entity/Entity;getFeetBlockState()Lnet/minecraft/world/level/block/state/BlockState;"}, at={@At(value="HEAD")}, cancellable=true)
    private void onGetBlockState(CallbackInfoReturnable<BlockState> cir) {
        Portal collidingPortal = this.ip_getCollidingPortal();
        Entity this_ = (Entity)this;
        if (collidingPortal != null && collidingPortal.getNormal().f_82480_ > 0.0) {
            BlockState result;
            BlockPos remoteLandingPos = BlockPos.m_274446_((Position)collidingPortal.transformPoint(this_.m_20182_()));
            Level destinationWorld = collidingPortal.getDestinationWorld();
            if (destinationWorld.m_46805_(remoteLandingPos) && !(result = destinationWorld.m_8055_(remoteLandingPos)).m_60795_()) {
                cir.setReturnValue((Object)result);
                cir.cancel();
            }
        }
    }

    @Override
    public Portal ip_getCollidingPortal() {
        if (this.ip_portalCollisionHandler == null) {
            return null;
        }
        if (this.ip_portalCollisionHandler.portalCollisions.isEmpty()) {
            return null;
        }
        return this.ip_portalCollisionHandler.portalCollisions.get((int)0).portal;
    }

    @Override
    public void ip_tickCollidingPortal() {
        Entity this_ = (Entity)this;
        if (this.ip_portalCollisionHandler != null) {
            this.ip_portalCollisionHandler.update(this_);
        }
        if (this.f_19853_.f_46443_) {
            IPMcHelper.onClientEntityTick(this_);
        }
    }

    @Override
    public void ip_notifyCollidingWithPortal(Entity portal) {
        Entity this_ = (Entity)this;
        if (this.ip_portalCollisionHandler == null) {
            this.ip_portalCollisionHandler = new PortalCollisionHandler();
        }
        this.ip_portalCollisionHandler.notifyCollidingWithPortal(this_, (Portal)portal);
    }

    @Override
    public boolean ip_isCollidingWithPortal() {
        if (this.ip_portalCollisionHandler == null) {
            return false;
        }
        return this.ip_portalCollisionHandler.hasCollisionEntry();
    }

    @Override
    public boolean ip_isRecentlyCollidingWithPortal() {
        if (this.ip_portalCollisionHandler == null) {
            return false;
        }
        return this.ip_portalCollisionHandler.isRecentlyCollidingWithPortal((Entity)this);
    }

    @Override
    public void ip_unsetRemoved() {
        this.m_146912_();
    }

    @Override
    @IPVanillaCopy
    public void ip_setPositionWithoutTriggeringCallback(Vec3 newPos) {
        double x = newPos.f_82479_;
        double y = newPos.f_82480_;
        double z = newPos.f_82481_;
        if (this.f_19825_.f_82479_ != x || this.f_19825_.f_82480_ != y || this.f_19825_.f_82481_ != z) {
            this.f_19825_ = new Vec3(x, y, z);
            int bx = Mth.m_14107_((double)x);
            int by = Mth.m_14107_((double)y);
            int bz = Mth.m_14107_((double)z);
            if (bx != this.f_19826_.m_123341_() || by != this.f_19826_.m_123342_() || bz != this.f_19826_.m_123343_()) {
                this.f_19826_ = new BlockPos(bx, by, bz);
                this.f_185934_ = null;
                if (SectionPos.m_123171_((int)bx) != this.f_185933_.f_45578_ || SectionPos.m_123171_((int)bz) != this.f_185933_.f_45579_) {
                    this.f_185933_ = new ChunkPos(this.f_19826_);
                }
            }
        }
    }

    @Override
    public void ip_clearCollidingPortal() {
        this.ip_portalCollisionHandler = null;
    }

    @Override
    @Nullable
    public AABB ip_getActiveCollisionBox(AABB originalBox) {
        Entity this_ = (Entity)this;
        if (this.ip_portalCollisionHandler == null) {
            return originalBox;
        }
        return this.ip_portalCollisionHandler.getActiveCollisionBox(this_, originalBox);
    }

    @Override
    @Nullable
    public PortalCollisionHandler ip_getPortalCollisionHandler() {
        return this.ip_portalCollisionHandler;
    }

    @Override
    public PortalCollisionHandler ip_getOrCreatePortalCollisionHandler() {
        if (this.ip_portalCollisionHandler == null) {
            this.ip_portalCollisionHandler = new PortalCollisionHandler();
        }
        return this.ip_portalCollisionHandler;
    }

    @Override
    public void ip_setPortalCollisionHandler(@Nullable PortalCollisionHandler handler) {
        this.ip_portalCollisionHandler = handler;
    }

    @Override
    public void ip_setWorld(Level world) {
        this.f_19853_ = world;
    }

    private long ip_getStableTiming() {
        return this.f_19797_;
    }
}

